// SleepDialog.cpp : implementation file
//

#include "stdafx.h"
#include "DcDcUsb.h"
#include "DcDcUsbDlg.h"
#include "SleepDialog.h"


// CSleepDialog dialog

IMPLEMENT_DYNAMIC(CSleepDialog, CDialog)

CSleepDialog::CSleepDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSleepDialog::IDD, pParent)
	, m_strSleep(_T("00:00:00"))
{

}

CSleepDialog::~CSleepDialog()
{
}

void CSleepDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_SLEEP, m_strSleep);
}


BEGIN_MESSAGE_MAP(CSleepDialog, CDialog)
	ON_BN_CLICKED(IDOK, &CSleepDialog::OnBnClickedOk)
END_MESSAGE_MAP()


// CSleepDialog message handlers

void CSleepDialog::OnBnClickedOk()
{
	UpdateData(TRUE);

	if ((m_strSleep.GetLength()==8)&&(m_strSleep[2]==':')&&(m_strSleep[5]==':'))
	{
		_TCHAR* end = NULL;

		int dd  = _tcstol(m_strSleep.Left(2), &end, 10);
		if (((errno != ERANGE)&&(errno != EINVAL))&&(dd>=0)&&(dd<46))
		{
			int hh  = _tcstol(m_strSleep.Mid(3,2), &end, 10);
			if (((errno != ERANGE)&&(errno != EINVAL))&&(hh>=0)&&(hh<60))
			{
				int mm  = _tcstol(m_strSleep.Right(2), &end, 10);

				if (((errno != ERANGE)&&(errno != EINVAL))&&(mm>=0)&&(mm<60))
				{
					unsigned long minutes = dd*24*60+hh*60+mm;

					if (minutes < 65536)
					{
						if (((CDcDcUsbDlg*)AfxGetMainWnd())->m_pDcDcUsb)
							((CDcDcUsbDlg*)AfxGetMainWnd())->m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SLEEP
													, (minutes >> 8)& 0xFF
													, minutes & 0xFF );

						OnOK();
						return;
					}
				}
			}
		}
	}

	AfxMessageBox("Invalid or too big time - format is dd:hh:mm (max: 45:12:15)!");
}
