#include <string.h>
#include "dev_util.h"
#include "qmux_util.h"
#include "proc_util.h"

int OpenTransport(QmuxTransport* ptransport, char* dev_path, size_t dev_path_size, int* pmode, int* pif_adapter,
	bool valid, FNSHOWHELP pfnsh, const char* pProcName, bool showhelp)
{
	if (*pmode != QMUX_INTERFACE_ROUTER)
	{
		if (ptransport == NULL ||
			!GetDeviceInfo(dev_path, dev_path_size, pmode, pif_adapter, valid, pfnsh, pProcName, showhelp))
			return 1;
	}

	dlog(eLOG_INFO, "Open transport \"%s\" in %s mode\n", dev_path, GetModeDesc(*pmode));

	//if (QmuxTransport_Initialize(ptransport, dev_path, *pmode == QMUX_INTERFACE_MBIM, NULL) != 0)
	if (QmuxTransport_InitializeEx(ptransport, *pmode != QMUX_INTERFACE_ROUTER ? dev_path : NULL, *pmode, NULL) != 0)
	{
		dlog(eLOG_ERROR, "Transport_Initialize failed.\n");
		return 2;
	}

	return 0;
}

